let blancs n = make_string n ` `;;
let disque taille =
    let moiti_droite = make_string taille `>`
    and moiti_gauche = make_string taille `<`
    in moiti_gauche ^ "|" ^ moiti_droite;;
let disque_numro n taille_grand_disque =
    let partie_blanche = blancs (taille_grand_disque + 1 - n) in
    partie_blanche ^ (disque n) ^ partie_blanche;;
let base_de_tige taille_grand_disque =
    let moiti = make_string taille_grand_disque `_` in
    " " ^ moiti ^ "|" ^ moiti ^ " ";;
let rec tige taille_grand_disque = function
  | (0, []) -> []
  | (0, tte::reste) ->
      disque_numro tte taille_grand_disque ::
      tige taille_grand_disque (0, reste)
  | (dcalage, liste) ->
      disque_numro 0 taille_grand_disque ::
      tige taille_grand_disque (dcalage-1, liste);;
let rec recolle l1 l2 l3 =
  match (l1, l2, l3) with
  | ([], [], []) -> []
  | (t1::r1, t2::r2, t3::r3) -> (t1 ^ t2 ^ t3) :: recolle r1 r2 r3
  | _ -> failwith "recolle";;
let imprime ligne = print_string ligne; print_newline();;
let imprime_jeu nombre_de_disques dpart milieu arrive =
    let dessin =
        recolle (tige nombre_de_disques dpart)
                (tige nombre_de_disques milieu)
                (tige nombre_de_disques arrive) in
    do_list imprime dessin;
    let b = base_de_tige nombre_de_disques in imprime (b ^ b ^ b);;
let ajoute_disque disque (dcalage, disques as tige) =
    (dcalage - 1, disque::disques);;
let sommet = function
  | (dcalage, sommet :: reste) -> sommet
  | (dcalage, []) -> failwith "sommet: tige vide";;
let enlve_sommet = function
  | (dcalage, sommet :: reste) -> (dcalage + 1, reste)
  | (dcalage, []) -> failwith "enlve_sommet: tige vide";;
let dplace (nom_dpart, tige_dpart) (nom_arrive, tige_arrive) =
    imprime("Je dplace un disque de " ^
            nom_dpart ^ "  " ^ nom_arrive);
    let disque_dplac = sommet !tige_dpart in
    tige_dpart := enlve_sommet !tige_dpart;
    tige_arrive := ajoute_disque disque_dplac !tige_arrive;;
let tige_vide nombre_de_disques = (nombre_de_disques, []);;
let tige_pleine nombre_de_disques =
    let rec liste_des_disques i =
        if i <= nombre_de_disques
        then i :: liste_des_disques (i+1)
        else [] in
    (0, liste_des_disques 1);;
let jeu nombre_de_disques =
    let gauche = ref (tige_pleine nombre_de_disques)
    and milieu = ref (tige_vide nombre_de_disques)
    and droite = ref (tige_vide nombre_de_disques) in
    let rec hanoi hauteur dpart intermdiaire destination =
        if hauteur > 0 then
         begin
           hanoi (hauteur - 1) dpart destination intermdiaire;
           dplace dpart destination;
           imprime_jeu nombre_de_disques !gauche !milieu !droite;
           hanoi (hauteur - 1) intermdiaire dpart destination
         end in
    imprime "J'appelle les tiges A, B et C.";
    imprime "Position de dpart:";
    imprime_jeu nombre_de_disques !gauche !milieu !droite;
    hanoi nombre_de_disques
          ("A", gauche) ("B", milieu) ("C", droite);;
if sys__interactive then () else begin
  jeu (int_of_string (sys__command_line.(1)));
  exit 0
end;;
